#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <signal.h>
#include <stdlib.h>
#include <wait.h>
#include <time.h>
#include <fcntl.h>
#include "../config.h"


FILE *logf;
int logg=0;

struct sockaddr_in cliaddr, servaddr;

int main (int argc, char *argv[]){
	int newsock;
	int client,  argcount = 0;
	struct options {
		int help;
	        char logfile[20];
	        char tablename[30];
	        uint16_t port;
	} options;

//Default Values

	options.port = 7799;
	strcpy(options.tablename, "");

// Handling parameters

	for (argcount = 1; argcount < argc; argcount++){
		if (!strcmp(argv[argcount],"-h")){
			options.help = 1;
			print_help (argv[0]);
		} 
		if (!strcmp(argv[argcount],"-l")){
			logg = 1;
			if (++argcount >= argc) print_help(argv[0]);
			strcpy(options.logfile, argv[argcount]);
			if (options.logfile[0] == '-') print_help(argv[0]);
			printf ("Logfile: %s\n", options.logfile);
		} 

		if (!strcmp(argv[argcount],"-t")){
			if (++argcount >= argc) print_help(argv[0]);
			strcpy(options.tablename, argv[argcount]);
			if (options.tablename[0] == '-') print_help(argv[0]);
			printf ("Tablename: %s\n", options.tablename);
		} 

		if (!strcmp(argv[argcount],"-p")){
			if (++argcount >= argc) print_help(argv[0]);
			if (atoi(argv[argcount])==0) print_help(argv[0]);
			options.port = atoi(argv[argcount]);
			printf ("Port: %d\n", options.port);
		} 
	}


	fortune_get(options.tablename, 1);

	if (logg==1) {
		logf = fopen (options.logfile, "a");
	}

	sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (sock < 0){ 
		fprintf (stderr, "Cannot open Socket\n");
		return 1;
	}

	servaddr.sin_family = AF_INET;
	servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
	servaddr.sin_port = htons(options.port);
	
	if (bind(sock, (struct sockaddr *) &servaddr, sizeof(servaddr))<0) {
		fprintf (stderr, "Cannot Bind PORT\n");
		return 1;
	}

	listen (sock, 50);

	printf ("Fortune world server is listening on port %d ..\n", options.port);
	client = sizeof(cliaddr);  

	while (1){
	check_signals();
	newsock = accept(sock, (struct sockaddr *) &cliaddr, &client);

		if (newsock < 0){
			fprintf (stderr, "Error when accepting connection. \n");
			if (logg==1) fprintf (logf, "Error when accepting connection. \n");
		}

	nc(newsock, options.tablename);
	close (newsock);
	newsock = 0;

	}

return 1;
}

int nc(int newsock, char table[30]){
	char *fortune, *strtime;
	char *command=malloc(255);
	time_t aaalo;
	pid_t child_pid;
	int child_status;
	child_pid = fork();
	switch (child_pid) {
	    case -1:
		perror("fork");
		exit(1);
	    case 0:
//		read (newsock, command, 255);
			fortune = stripslashes(fortune_get(table, 0));
			write (newsock, fortune, strlen(fortune));

	aaalo = (time_t) time(0);
	strtime=ctime(&aaalo);
	strtime[strlen(strtime) -1]='\0';
	if (logg==1) fprintf (logf, "  -  %s  -   %s\n", strtime , inet_ntoa(cliaddr.sin_addr));
			free(fortune);
			free(command);
		close (newsock);
		exit(0);
	    default:
		wait(&child_status);
	}
return 1;
}
